<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	http://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There area two reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router what URI segments to use if those provided
| in the URL cannot be matched to a valid route.
|
*/

//set default controller differently if using the admin panel domain
if(defined('API_ADMINPANEL_DOMAIN') && strstr($_SERVER['HTTP_HOST'], API_ADMINPANEL_DOMAIN)) {
	$route['default_controller'] = 'admin/applications';
}
else { $route['default_controller'] = 'admin/direct'; }
$route['404_override'] = '';

/* Admin Panel Routes */
/* onboarding routes */
$route['onboarding/request'] = 'admin/onboarding/onboarding_request/';
$route['onboarding/request/edit/(:any)'] = 'admin/onboarding/onboarding_request_edit/$1';

/* applications routes */
$route['applications/list'] = 'admin/applications/application_list/';
$route['applications/edit/(:any)'] = 'admin/applications/application_edit/$1';

/* reports routes */
$route['reports/requests'] = 'admin/reports/report_requests/';
$route['reports/events'] = 'admin/reports/report_events/';
$route['reports/logins'] = 'admin/reports/report_logins/';
$route['reports/mail'] = 'admin/reports/report_mail/';
$route['reports/tickets'] = 'admin/reports/report_tickets/';

/* admin routes */
$route['administration/manage/accounts'] = 'admin/administration/admin_manage_accounts/';
$route['administration/manage/accounts/edit/access/(:any)'] = 'admin/administration/admin_edit_account_access/$1';
$route['administration/manage/accounts/edit/(:any)'] = 'admin/administration/admin_edit_account/$1';
$route['administration/manage/accounts/disable'] = 'admin/administration/disable_account/';
$route['administration/manage/accounts/enable'] = 'admin/administration/enable_account/';
$route['administration/application/requests'] = 'admin/administration/admin_request_list/';
$route['administration/account/requests'] = 'admin/administration/account_request_list/';
$route['administration/manage/groups'] = 'admin/administration/admin_manage_groups/';
$route['administration/manage/groups/edit/access/(:any)'] = 'admin/administration/admin_edit_group_access/$1';
$route['administration/manage/groups/edit/(:any)'] = 'admin/administration/admin_edit_group/$1';
$route['administration/manage/groups/disable'] = 'admin/administration/disable_group/';
$route['administration/manage/groups/enable'] = 'admin/administration/enable_group/';
/* ------------------- */

/* Admin API routes */
$route['admin/create/user'] = 'services/admin/create_user/';
$route['admin/create/group'] = 'services/admin/create_group/';

/* ------------------- */

/*Re-route sub-directories for controllers to top-level */
/* admin pages */
$route['onboarding'] = 'admin/onboarding';
$route['onboarding/(:any)'] = 'admin/onboarding/$1';
$route['applications'] = 'admin/applications';
$route['applications/(:any)'] = 'admin/applications/$1';
$route['reports'] = 'admin/reports';
$route['reports/(:any)'] = 'admin/reports/$1';
$route['administration'] = 'admin/administration';
$route['administration/(:any)'] = 'admin/administration/$1';
$route['support'] = 'admin/support';
$route['support/(:any)'] = 'admin/support/$1';

/* services */
$route['direct'] = 'services/direct';
$route['direct/(:any)'] = 'services/direct/$1';
$route['admin'] = 'services/admin';
$route['admin/(:any)'] = 'services/admin/$1';

/* ------------------- */

/* End of file routes.php */
/* Location: ./application/config/routes.php */